/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.mixin.BoatAccessor;
import com.talhanation.smallships.world.entity.ship.Attributes;
import com.talhanation.smallships.world.entity.ship.abilities.Bannerable;
import com.talhanation.smallships.world.entity.ship.abilities.Cannonable;
import com.talhanation.smallships.world.entity.ship.abilities.Sailable;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class Ship
extends class_1690 {
    public static final class_2940<class_2487> ATTRIBUTES = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13318);
    public static final class_2940<Float> SPEED = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13320);
    public static final class_2940<Byte> SAIL_STATE = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    public static final class_2940<String> SAIL_COLOR = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13326);
    public static final class_2940<class_1799> BANNER = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13322);
    public static final class_2940<Byte> CANNON_COUNT_RIGHT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> CANNON_COUNT_LEFT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> CANNON_COOLDOWN_RIGHT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    public static final class_2940<Byte> CANNON_COOLDOWN_LEFT = class_2945.method_12791(Ship.class, (class_2941)class_2943.field_13319);
    private float prevWaveAngle;
    private float waveAngle;
    public float prevBannerWaveAngle;
    public float bannerWaveAngle;

    public Ship(class_1299<? extends class_1690> entityType, class_1937 level) {
        super(entityType, level);
        if (this.method_5797() == null) {
            this.method_5665((class_2561)class_2561.method_43470((String)StringUtils.capitalize((String)class_1299.method_5890((class_1299)this.method_5864()).method_12832())));
        }
        this.field_6013 = 0.6f;
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(SPEED, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(ATTRIBUTES, (Object)this.createDefaultAttributes());
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.defineSailShipSynchedData();
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.defineBannerShipSynchedData();
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.defineCannonShipSynchedData();
        }
    }

    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(tag, this);
        this.setData(ATTRIBUTES, attributes.getSaveData());
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.readSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.readBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.readCannonShipSaveData(tag);
        }
    }

    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        attributes.addSaveData(tag);
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.addSailShipSaveData(tag);
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.addBannerShipSaveData(tag);
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.addCannonShipSaveData(tag);
        }
    }

    public <T> T getData(class_2940<T> accessor) {
        return (T)this.method_5841().method_12789(accessor);
    }

    public <T> void setData(class_2940<T> accessor, T value) {
        this.method_5841().method_12778(accessor, value);
    }

    public void method_5773() {
        super.method_5773();
        this.updateWaveAngle();
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            sailShip.tickSailShip();
        }
        if ((ship = this) instanceof Bannerable) {
            Bannerable bannerShip = (Bannerable)((Object)ship);
            bannerShip.tickBannerShip();
        }
        if ((ship = this) instanceof Cannonable) {
            Cannonable cannonShip = (Cannonable)((Object)ship);
            cannonShip.tickCannonShip();
        }
    }

    protected void method_7549() {
        if (this.method_5782()) {
            boolean isInputForward;
            Attributes attributes = this.getAttributes();
            if (((BoatAccessor)((Object)this)).isInputLeft()) {
                ((BoatAccessor)((Object)this)).setDeltaRotation(((BoatAccessor)((Object)this)).getDeltaRotation() - attributes.maxRotationSpeed);
            }
            if (((BoatAccessor)((Object)this)).isInputRight()) {
                ((BoatAccessor)((Object)this)).setDeltaRotation(((BoatAccessor)((Object)this)).getDeltaRotation() + attributes.maxRotationSpeed);
            }
            this.method_36456(this.method_36454() + ((BoatAccessor)((Object)this)).getDeltaRotation());
            float speed = Math.max(this.getData(SPEED).floatValue() - attributes.friction, 0.0f);
            boolean bl = ((BoatAccessor)((Object)this)).isInputUp() || (this instanceof Sailable ? (int)this.getData(SAIL_STATE).byteValue() : 0) > 0 ? true : (isInputForward = false);
            if (((BoatAccessor)((Object)this)).isInputRight() != ((BoatAccessor)((Object)this)).isInputLeft() && !isInputForward && !((BoatAccessor)((Object)this)).isInputDown()) {
                speed = Math.min(speed + attributes.acceleration, attributes.maxReverseSpeed);
            }
            if (isInputForward) {
                speed = Math.min(speed + attributes.acceleration, attributes.maxSpeed);
            }
            if (((BoatAccessor)((Object)this)).isInputDown()) {
                speed = Math.max(speed - attributes.acceleration, -attributes.maxReverseSpeed);
            }
            this.setData(SPEED, Float.valueOf(speed));
            this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * speed), 0.0, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * speed)));
        }
    }

    public class_1269 method_5688(@NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        Bannerable bannerShip;
        Sailable sailShip;
        Cannonable cannonShip;
        Ship ship = this;
        if (ship instanceof Cannonable && (cannonShip = (Cannonable)((Object)ship)).interactCannon(player, interactionHand)) {
            return class_1269.field_5812;
        }
        ship = this;
        if (ship instanceof Sailable && (sailShip = (Sailable)((Object)ship)).interactSail(player, interactionHand)) {
            return class_1269.field_5812;
        }
        ship = this;
        if (ship instanceof Bannerable && (bannerShip = (Bannerable)((Object)ship)).interactBanner(player, interactionHand)) {
            return class_1269.field_5812;
        }
        return super.method_5688(player, interactionHand);
    }

    public class_243 method_24829(@NotNull class_1309 livingEntity) {
        Ship ship = this;
        if (ship instanceof Sailable) {
            Sailable sailShip = (Sailable)((Object)ship);
            if (this.getData(SAIL_STATE) != 0) {
                sailShip.toggleSail();
            }
        }
        return super.method_24829(livingEntity);
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.75;
    }

    private void updateWaveAngle() {
        this.prevWaveAngle = this.waveAngle;
        this.waveAngle = (float)Math.sin(this.getWaveSpeed() * (float)this.field_6012) * this.getWaveFactor();
    }

    private float getWaveFactor() {
        return this.field_6002.method_8419() ? 3.0f : 1.25f;
    }

    private float getWaveSpeed() {
        return this.field_6002.method_8419() ? 0.12f : 0.03f;
    }

    public float getWaveAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevWaveAngle, (float)this.waveAngle);
    }

    public Attributes getAttributes() {
        Attributes attributes = new Attributes();
        attributes.loadSaveData(this.getData(ATTRIBUTES));
        return attributes;
    }

    protected abstract int method_42281();

    public abstract class_1792 method_7557();

    public abstract class_2487 createDefaultAttributes();
}

